// File: LEDblinker.h
// This file contains all LED blinker definitions
// Author: dr. Matej Kseneman

#ifndef LED_BLINKER_H
#define LED_BLINKER_H

// Define where user port LEDs are
#define LEDS_GPIO_PORT		GPIOE
#define LEDS_GPIO_CLK		RCC_AHB1Periph_GPIOE

#define RED_LED				GPIO_Pin_2	// PE2
#define WHITE_LED			GPIO_Pin_3	// PE3
#define ORANGE_LED			GPIO_Pin_4	// PE4
#define GREEN_LED			GPIO_Pin_5	// PE5
#define BLUE_LED			GPIO_Pin_6	// PE6
#define ALL_EXTERNAL_LEDS	(RED_LED | WHITE_LED | ORANGE_LED | GREEN_LED | BLUE_LED)

// Function pointer to the current LED configuration
extern void (*toggleLed)(void);

// Initialize periphery
void InitBlinker();

// Toggle LED state in a forward direction
void ToggleLedForward();

// Toggle LED state in a backward direction
void ToggleLedBackward();

// Change LEDs direction
void ChangeLedDirection();

#endif	// LED_BLINKER_H
