// File: delay.h
// This file contains information for delay manipulation
// Author: dr. Matej Kseneman

#ifndef DELAY_H
#define DELAY_H

#include "stm32f4_discovery.h"

// Exported variables
extern volatile uint32_t TimerOverflow;

// Initialize timer TIM7 in microseconds
void InitUsTimer();

// Get time in microsecond ticks
uint64_t GetMicroSecondTime();

// Delay for milliseconds
void DelayMilliSeconds(uint32_t nTime);

// Delay for microseconds
void DelayMicroSeconds(uint64_t usTime);

#endif  // DELAY_H
