// Blinky project
// Author: Matej Kseneman

// Project includes
#include "STM32F4_Discovery.h"
#include "Delay/delay.h"
#include "Delay/LEDblinker.h"

#define TIME_BETWEEN_TOGGLE		500	// ms

int main(void)
{
	// Set up microsecond timer
	InitUsTimer();

	// Initialize LED blinker
	InitBlinker();

	while (1)
	{
		(*toggleLed)();
		DelayMilliSeconds(TIME_BETWEEN_TOGGLE);
	}
}

#ifdef USE_FULL_ASSERT
/*******************************************************************************
* Function Name  : assert_failed
* Description    : Reports the name of the source file and the source line number
*                  where the assert_param error has occurred.
* Input          : - file: pointer to the source file name
*                  - line: assert_param error line source number
* Output         : None
* Return         : None
*******************************************************************************/
void assert_failed(uint8_t* file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {}
}
#endif
