$regfile = "m328pdef.dat"
$crystal = 16000000
$hwstack = 20
$swstack = 20
$framesize = 80

'VlaM =======================Configurations======================================

Config Submode = New          'use sub/function without Declare
Config Base = 0               'array index = 0

$include "Oled$SE.sub"        'include OLED subroutines

Config Clockdiv = 1

$lib "i2c_twi.lbx"            'use TWI instead software emulated I2C
Config Twi = 400000           'I2C clock speed

Oled Alias Portc              'determine Oled port
Config Scl = Oled.5           'Oled SCL pin name
Config Sda = Oled.4           'Oled SDA pin name
I2cinit

Oled$reset_pin Alias Portc.3  'Oled reset pin name
Oled$reset_pin = 1
Config Pinc.3 = Output

'VlaM =======================Main program========================================

Oled$reset
Wait 1

Dim Temp As Byte , Temp_str As String * 4

Oled$clear

Oled$write_byte &B11111111 , 0 , 0

For Temp = 1 To 127
   Oled$send_dta , &B11111111
Next

Oled$write_byte &B10101010 , 1 , 0

For Temp = 1 To 127 Step 2
   Oled$send_dta , 0
   Oled$send_dta , &B10101010
Next

Oled$write_byte &B10101010 , 6 , 0

For Temp = 1 To 127 Step 2
   Oled$send_dta , 0
   Oled$send_dta , &B10101010
Next

Oled$write_byte &B11111111 , 7 , 0

For Temp = 1 To 127
   Oled$send_dta , &B11111111
Next

Oled$write_text "Podeavanje kontrasta" , 3 , 1
Oled$write_text "Kontrast = " , 4 , 20

Do
   For Temp = 0 To 255
      Temp_str = Str(temp)
      Oled$write_text Temp_str , 4 , 86
      Oled$send_cmd &B10000001
      Oled$send_cmd Temp
      Waitms 20
   Next
   For Temp = 250 To 0 Step -10
      Temp_str = Str(temp) + " "
      Oled$write_text Temp_str , 4 , 86
      Oled$send_cmd &B10000001
      Oled$send_cmd Temp
      Waitms 500
   Next
Loop
