$regfile = "m328pdef.dat"
$crystal = 16000000
$hwstack = 20
$swstack = 20
$framesize = 80

'VlaM =======================Configurations======================================

Config Submode = New          'use sub/function without Declare
Config Base = 0               'array index = 0

$include "Oled$SE.sub"        'include OLED subroutines

Config Clockdiv = 1

$lib "i2c_twi.lbx"            'use TWI instead software emulated I2C
Config Twi = 400000           'I2C clock speed

Oled Alias Portc              'determine Oled port
Config Scl = Oled.5           'Oled SCL pin name
Config Sda = Oled.4           'Oled SDA pin name
I2cinit

Oled$reset_pin Alias Portc.3  'Oled reset pin name
Oled$reset_pin = 1
Config Pinc.3 = Output

'VlaM =======================Main program========================================

Oled$reset
Wait 1

Dim Sin_row As Byte , Sin_col As Byte
Dim Temp_row(64) As Byte , Temp_col(64) As Byte , Temp_ind As Byte

Oled$clear

For Temp_ind = 0 To 63
   Temp_row(temp_ind) = 0
   Temp_col(temp_ind) = 0
Next

Do
   Restore Sinusoida
   For Sin_col = 0 To 127
      Read Sin_row
      Oled$set_pix_on Sin_row , Sin_col
      Oled$set_pix_off Temp_row(0) , Temp_col(0)
      For Temp_ind = 0 To 62
         Temp_row(temp_ind) = Temp_row(temp_ind + 1)
         Temp_col(temp_ind) = Temp_col(temp_ind + 1)
      Next
      Temp_row(63) = Sin_row
      Temp_col(63) = Sin_col
      Waitms 10
   Next
Loop

Sinusoida:
Data 31
Data 29
Data 28
Data 26
Data 25
Data 23
Data 22
Data 21
Data 19
Data 18
Data 16
Data 15
Data 14
Data 13
Data 11
Data 10
Data 9
Data 8
Data 7
Data 6
Data 5
Data 4
Data 4
Data 3
Data 2
Data 2
Data 1
Data 1
Data 1
Data 0
Data 0
Data 0
Data 0
Data 0
Data 0
Data 0
Data 1
Data 1
Data 1
Data 2
Data 2
Data 3
Data 4
Data 4
Data 5
Data 6
Data 7
Data 8
Data 9
Data 10
Data 11
Data 13
Data 14
Data 15
Data 16
Data 18
Data 19
Data 21
Data 22
Data 23
Data 25
Data 26
Data 28
Data 29
Data 31
Data 33
Data 34
Data 36
Data 37
Data 39
Data 40
Data 41
Data 43
Data 44
Data 46
Data 47
Data 48
Data 49
Data 51
Data 52
Data 53
Data 54
Data 55
Data 56
Data 57
Data 58
Data 58
Data 59
Data 60
Data 60
Data 61
Data 61
Data 61
Data 62
Data 62
Data 62
Data 62
Data 62
Data 62
Data 62
Data 61
Data 61
Data 61
Data 60
Data 60
Data 59
Data 58
Data 58
Data 57
Data 56
Data 55
Data 54
Data 53
Data 52
Data 51
Data 49
Data 48
Data 47
Data 46
Data 44
Data 43
Data 41
Data 40
Data 39
Data 37
Data 36
Data 34
Data 33
Data 31
