$regfile = "m328pdef.dat"
$crystal = 16000000
$hwstack = 20
$swstack = 20
$framesize = 80

'VlaM =======================Configurations======================================

Config Submode = New          'use sub/function without Declare
Config Base = 0               'array index = 0

$include "Oled$SE.sub"        'include OLED subroutines

Config Clockdiv = 1

$lib "i2c_twi.lbx"            'use TWI instead software emulated I2C
Config Twi = 400000           'I2C clock speed

Oled Alias Portc              'determine Oled port
Config Scl = Oled.5           'Oled SCL pin name
Config Sda = Oled.4           'Oled SDA pin name
I2cinit

Oled$reset_pin Alias Portc.3  'Oled reset pin name
Oled$reset_pin = 1
Config Pinc.3 = Output

'VlaM =======================Main program========================================

Oled$reset
Wait 1

Oled$clear

Oled$set_pix_on 0 , 0
Oled$set_pix_on 0 , 1
Oled$set_pix_on 1 , 0
Oled$set_pix_on 63 , 126
Oled$set_pix_on 63 , 127
Oled$set_pix_on 62 , 127
Oled$set_pix_off 0 , 126
Oled$set_pix_off 0 , 127
Oled$set_pix_off 1 , 127
Oled$set_pix_off 63 , 1
Oled$set_pix_off 63 , 0
Oled$set_pix_off 62 , 0
Wait 1
Oled$set_pix_off 0 , 0
Oled$set_pix_off 0 , 1
Oled$set_pix_off 1 , 0
Oled$set_pix_off 63 , 126
Oled$set_pix_off 63 , 127
Oled$set_pix_off 62 , 127
Oled$set_pix_on 0 , 126
Oled$set_pix_on 0 , 127
Oled$set_pix_on 1 , 127
Oled$set_pix_on 63 , 1
Oled$set_pix_on 63 , 0
Oled$set_pix_on 62 , 0
Wait 1

Dim Temp_col As Byte , Temp_row As Byte
Dim Temp_rnd As Word At Temp_col Overlay

Do
   Temp_rnd = Rnd(0)
   Oled$set_pix_on Temp_row , Temp_col
   Swap Temp_row , Temp_col
   Oled$set_pix_off Temp_row , Temp_col
Loop

