$regfile = "m328pdef.dat"
$crystal = 16000000
$hwstack = 20
$swstack = 20
$framesize = 80

'VlaM =======================Configurations======================================

Config Submode = New          'use sub/function without Declare
Config Base = 0               'array index = 0

$include "Oled$SE.sub"        'include OLED subroutines

Config Clockdiv = 1

$lib "i2c_twi.lbx"            'use TWI instead software emulated I2C
Config Twi = 400000           'I2C clock speed

Oled Alias Portc              'determine Oled port
Config Scl = Oled.5           'Oled SCL pin name
Config Sda = Oled.4           'Oled SDA pin name
I2cinit

Oled$reset_pin Alias Portc.3  'Oled reset pin name
Oled$reset_pin = 1
Config Pinc.3 = Output

'VlaM =======================Main program========================================

Oled$reset
Wait 1

Dim Row As Byte , Row1 As Byte , Row2 As Byte
Dim Col As Byte , Col1 As Byte , Col2 As Byte

Do

Oled$clear

For Row1 = 0 To 30 Step 2
   Row2 = 63 - Row1
   Col1 = 34 - Row1
   Col2 = 128 - Col1
   For Col = Col1 To Col2
      Oled$set_pix 1 , Row1 , Col
   Next
   Col1 = Col1 - 2
   For Row = Row1 To Row2
      Oled$set_pix 1 , Row , Col2
   Next
   For Col = Col2 To Col1 Step -1
      Oled$set_pix 1 , Row2 , Col
   Next
   For Row = Row2 To Row1 Step -1
      Oled$set_pix 1 , Row , Col1
   Next
   Col2 = Col1 + 2
   For Col = Col1 To Col2
      Oled$set_pix 1 , Row1 , Col
   Next
Next

Wait 1

For Row1 = 0 To 30 Step 2
   Row2 = 63 - Row1
   Col1 = 32 - Row1
   Col2 = 126 - Col1
   For Col = Col1 To Col2
      Oled$set_pix 0 , Row1 , Col
   Next
   For Row = Row1 To Row2
      Oled$set_pix 0 , Row , Col2
   Next
   For Col = Col2 To Col1 Step -1
      Oled$set_pix 0 , Row2 , Col
   Next
   For Row = Row2 To Row1 Step -1
      Oled$set_pix 0 , Row , Col1
   Next
Next

Wait 1

Loop
