$regfile = "m328pdef.dat"
$crystal = 16000000
$hwstack = 20
$swstack = 20
$framesize = 80

'VlaM =======================Configurations======================================

Config Submode = New          'use sub/function without Declare
Config Base = 0               'array index = 0

$include "Oled$SE.sub"        'include OLED subroutines

Config Clockdiv = 1

$lib "i2c_twi.lbx"            'use TWI instead software emulated I2C
Config Twi = 400000           'I2C clock speed

Oled Alias Portc              'determine Oled port
Config Scl = Oled.5           'Oled SCL pin name
Config Sda = Oled.4           'Oled SDA pin name
I2cinit

Oled$reset_pin Alias Portc.3  'Oled reset pin name
Oled$reset_pin = 1
Config Pinc.3 = Output

'VlaM =======================Main program========================================

Oled$reset
Wait 1

Dim Temp_col As Byte , Temp_byte As Byte

Oled$clear
Wait 1

For Temp_col = 0 To 127
   Oled$write_byte Temp_col , 0 , Temp_col
Next
Wait 1

Do
   Oled$$set_adr 0 , 0
   I2cwbyte &B10000000        'next byte is a command byte
   I2cwbyte &B11100000        'Read-Modify-Write start
   I2cwbyte &B01000000        'instruct OLED to send data bytes
   For Temp_col = 0 To 127
      I2cstart
      I2cwbyte Oled$addr_r    'OLED read address
      I2crbyte Temp_byte , Ack
      I2crbyte Temp_byte , Nack       'read a byte
      Temp_byte = Not Temp_byte       'edit it
      I2cstart
      I2cwbyte Oled$addr_w    'OLED write address
      I2cwbyte &B01000000     'next byte is a data byte
      I2cwbyte Temp_byte      'write edited byte back to OLED
   Next
   I2cstart
   I2cwbyte Oled$addr_w       'OLED write address
   I2cwbyte &B10000000        'next byte is a command byte
   I2cwbyte &B11101110        'Read-Modify-Write end 
   I2cstop

   Wait 2
Loop
