$regfile = "m328pdef.dat"
$crystal = 16000000
$hwstack = 20
$swstack = 20
$framesize = 80

'VlaM =======================Configurations======================================

Config Submode = New          'use sub/function without Declare
Config Base = 0               'array index = 0

$include "Oled$SE.sub"        'include OLED subroutines

Config Clockdiv = 1

$lib "i2c_twi.lbx"            'use TWI instead software emulated I2C
Config Twi = 400000           'I2C clock speed

Oled Alias Portc              'determine Oled port
Config Scl = Oled.5           'Oled SCL pin name
Config Sda = Oled.4           'Oled SDA pin name
I2cinit

Oled$reset_pin Alias Portc.3  'Oled reset pin name
Oled$reset_pin = 1
Config Pinc.3 = Output

'VlaM =======================Main program========================================

Oled$reset
Wait 1

Dim Temp_page As Byte

Do
   Oled$clear
   Wait 1
   For Temp_page = 0 To 7
      If Temp_page.0 = 0 Then
         Oled$send_cmd &HA1   'Set_Segment_Re-map
      Else
         Oled$send_cmd &HA0   'Set_Segment_Re-map
      End If
      Oled$write_text "Svet elektronike" , Temp_page , 6
      Wait 1
   Next
Loop
